﻿var CAPIFileManegement = {
    context: $(".v-fileMangement"),
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".h-fileMangementTable", this.context).a4datatable({
            ajaxAction: a4.getAction("GetCAPIFiles", "MultiMode", "Settings"),
            displayColumnSelector: false,
            displaySearchBox: true,
            advancedFilter: true,
            columns: [
                { "Title": resources.Interviewer, "Data": "Interviewer" },
                { "Title": resources.FilePath, "Data": "FilePath" },
                { "Title": resources.FileName, "Data": "FileName" },
                { "Title": resources.ReceivedDate, "Data": "ReceivedDate", "Type": "date" },
                { "Title": resources.Size, "Data": "FormattedSize", "Name": "FormattedSize" }
            ],
            quickFilter: {
                "DisplayMode": "buttons",
                "IncludeAll": false,
                "Items": [{ "Label": resources.Received, "AjaxParams": { "type": 0 } },
                        { "Label": resources.Sent, "AjaxParams": { "type": 1 } }]
            },
            localizableTexts: { "Search": resources.SearchCAPIFiles },
            contextMenuItems: [
                { "Action": "deleteReceived", "Label": resources.Delete, "DisplayCondition": function (data) { return data.Type == 0; } },
                { "Action": "download", "Label": resources.Download, "DisplayCondition": function (data) { return data.Type == 0; } },
                { "Action": "deleteSent", "Label": resources.Delete, "DisplayCondition": function (data) { return data.Type == 1; } },
                { "Action": "removeCompleted", "Label": resources.RemoveCompleted, "DisplayCondition": function (data) { return data.Type == 1; } },
                { "Action": "interviewers", "Label": resources.Interviewers, "DisplayCondition": function (data) { return data.Type == 1; } }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "deleteReceived":
                        CAPIFileManegement.deleteReceived([row.Id]);
                        break;
                    case "download":
                        CAPIFileManegement.download([row.Id], [row.FileName]);
                        break;
                    case "deleteSent":
                        CAPIFileManegement.deleteSent([row.Id]);
                        break;
                    case "removeCompleted":
                        CAPIFileManegement.removeCompleted([row.Id]);
                        break;
                    case "interviewers":
                        modalDialog.showWindow(a4.getAction("Interviewers", "MultiMode", "Settings", { id: [row.Id] }), 500, 800);
                        break;
                }
            },
            applyQuickFilter: function (event, data) {
                var type = data.filter.params.type;
                $(this).a4datatable("toggleColumns", ["Interviewer", "ReceivedDate"], type == 0);
            },
            stateKey: "CAPIFileManagement"
        });
    },
    bindEvents: function () {
        CAPIFileManegement.context.on("click", ".h-uploadFile", function () {
            modalDialog.showWindow(a4.getAction("CAPIFileManagementUpload", "MultiMode", "Settings"), 300, 700, { afterClose: function () { CAPIFileManegement.refreshContent(); } });
        });

        CAPIFileManegement.context.on("click", ".h-fileMangementSettings", function () {
            modalDialog.showWindow(a4.getAction("CAPIFileManagementSettings", "MultiMode", "Settings"), 500, 800, { afterClose: function () { CAPIFileManegement.refreshContent(); } });
        });

    },
    refreshContent: function () {
        CAPIFileManegement.datatable.a4datatable("refresh", true);
    },
    deleteReceived: function (id) {
        modalDialog.showConfirmDelete(confirmDeleteReceivedFileResources, function () {
            a4.callServerMethod(a4.getAction("DeleteCAPIReceivedFile", "MultiMode", "Settings", { id: id }), null,
                function () {
                    CAPIFileManegement.refreshContent();
                });
        }, 1);
    },
    download: function (id, fileName) {
        window.location = a4.getAction("DownloadCAPIReceivedFile", "MultiMode", "Settings", { id: id, fileName: fileName });
        
    },
    deleteSent: function (id) {
        modalDialog.showConfirmDelete(confirmDeleteSentFileResources, function () {
            a4.callServerMethod(a4.getAction("DeleteCAPISentFile", "MultiMode", "Settings", { id: id }), null,
                function () {
                    CAPIFileManegement.refreshContent();
                });
        }, 1);
    },
    removeCompleted: function (id) {
        modalDialog.showConfirmDialog(confirmDeleteFileCompletedResources, function () {
            a4.callServerMethod(a4.getAction("RemoveCompletedCAPISentFile", "MultiMode", "Settings", { id: id }), null,
                function () {
                    CAPIFileManegement.refreshContent();
                });
        }, 250, 500, true, { "count": 1 });
    }
};
var capiFileManagementUpload = {
    context: $(".v-capiFileManagementUpload"),
    bindEvents: function () {
        capiFileManagementUpload.context.on("click", ".h-submitUpload", function () {
            var isValid = true;

            var files = $(".v-fileInput")[0].files;
            if (files.length <= 0) {
                a4.showErrorMessage(resources.fileInputError);
                isValid = false;
            }
            if (!capiFileManagementUpload.validateRequiredFields()) {
                isValid = false;
            }

            return isValid;
        });
    },
    validateRequiredFields: function () {
        var errorMessage = resources.requiredError;
        var requiredFields = $(".v-requiredField");
        var isValid = true;

        requiredFields.removeClass("input-validation-error");
        $(".field-validation-error").addClass("field-validation-valid").removeClass("field-validation-error").text("");

        requiredFields.each(function () {
            if ($.trim($(this).val()).length == 0) {
                isValid = false;
                var error = $("[data-valmsg-for='" + $(this).attr("name") + "']");

                $(this).addClass("input-validation-error");
                error.removeClass("field-validation-valid").addClass("field-validation-error").text(errorMessage);
            }
        });

        return isValid;
    }
};

$(document).ready(function () {
    if (CAPIFileManegement.context.length > 0) {
        CAPIFileManegement.initializeDataTable();
        CAPIFileManegement.bindEvents();
    }
    if (capiFileManagementUpload.context.length > 0) {
        capiFileManagementUpload.bindEvents();
    }
});